/**
 * Adds a <script>-Tag to the document which calls the url. The content of the url is retrieved in 
 * a new global variable.
 * 
 * @param url the url to call
 * @param params string of the parameters to add, each already seperated with & and =
 * @param global the variable to create
 */
function ajax_do(url, params, global) {
	// Create new JS element
	var jsel = document.createElement('SCRIPT');
	jsel.type = 'text/javascript';
	if(params==null) {
		jsel.src = url + '?variable='+global;
	} else {
		jsel.src = url + '?'+params+'&variable='+global;
	}
	// Append JS element (therefore executing the 'AJAX' call)
	Ext.getBody().appendChild(jsel);
	//document.body.appendChild(jsel);
}

var spawnGrid = [
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true],
    [true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true]
];

function getAvailableGrid(bounds,grid) {
	var result=[], width=bounds[2], height=bounds[3];
	for(var row=0; row<grid.length; row++) {
		for(var col=0; col<grid[row].length; col++) {
			var available = true;
			for(var y=row; y<grid.length && y<row+height; y++) {
				for(var x=col; x<grid[y].length && x<col+width; x++) {
					if(!grid[y][x]) available=false;
				}
			}
			if(available) result.push([col,row]);
		}
	}
	return result;
}

function setAvailableGrid(bounds,grid,available) {
	var left=bounds[0], top=bounds[1], width=bounds[2], height=bounds[3];
	for(var row=top; row<grid.length && row<top+height; row++) {
		for(var col=left; col<grid[row].length && col<left+width; col++) {
			grid[row][col]=available;
		}
	}
	return grid;
}

function getClosestAvailable(bounds,grid) {
	var col=bounds[0], row=bounds[1];
	var availables = getAvailableGrid(bounds,grid);
	var distances = new Array();
	for(var i=0; i<availables.length; i++) {
		var distance = Math.abs(availables[i][0]-col)+Math.abs(availables[i][1]-row);
		distances.push([i,distance]);
	}
	distances.sort(function(a,b) {
		return a[1]-b[1];
	});
	if(distances.length>0)
		return availables[distances[0][0]];
	else
		return false;
}

function getGridBounds(bounds) {
	var col = parseInt((bounds[0]-300)/150);
	col = (col<0) ? 0 : col; col = (col>25) ? 25 : col;
	var row = parseInt((bounds[1]-300)/150);
	row = (row<0) ? 0 : row; row = (row>25) ? 25 : row;
	var width = parseInt(bounds[2]/150)+1;
	var height = parseInt(bounds[3]/150)+1;
	
	return [col,row,width,height];	
}

function bufferedPost(chunks) {
	if(chunks.length>0) {
		var chunk = chunks[0];
		var array = chunks.slice(1);
		Ext.Cors.request({
			url: server+"upload.php",
			params: {
				data: chunk
			},
			method: 'POST',
			callback: function(result) {
				bufferedPost(array);
			}
		});
	} else {
		console.log("Buffered Post Done.");
	}
}

function fromLocalStorage(param) {
	var value = window.localStorage.getItem(param);
	if ((typeof value!="undefined") && value!=null && value!="") {
		return value;
	} else {
		if(param=="username") value = prompt("Bitte geben Sie Ihren Picasa-Benutzernamen an:");
		if(param=="password") value = prompt("Bitte geben Sie Ihr Picasa-Passwort an:");
		if((typeof value!="undefined") && value!=null && value!="") {
			window.localStorage.setItem(param,value);
			return value;
		}
	}
}

function getLastLogin() {
	var value = window.localStorage.getItem("login");
	if ((typeof value != "undefined") && value != null && value != "") {
		return value;
	} else {
		return Ext.Date.format(new Date(2010,0,1), 'c');
	}
}

//document.ontouchmove = function(event) {
//	event.preventDefault();
//}

var username = "ibes.unimelb";
var password = "1b3s+1s0l@t10n";
var server = 'http://photoalbum.incom-grosche.com/server/';
var userid, albumlist;